/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DefaultHandleFactory;
import com.ge.med.cse.cvf.util.HandleFactory;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.SwingUtilities;

public class CvImageGrid
extends XpRoiHandleContainer {
    private static final String DOTTEDLINE = "DOTTED";
    private static double GRIDSPACING = 30.0;
    private static double TICKSPACING = 10.0;
    private static double TICKLENGTH = 5.0;
    private static boolean GRIDLINES_ON = true;
    private static String LINESTYLE = "DOTTED";
    private int _numberOfTickLines = 0;
    private int _numberOfPolyLines = 0;
    private int _numberOfAxis = 0;
    private int _numberOfTexts = 0;
    private double _centerX = 0.0;
    private double _centerY = 0.0;
    private int _rectWidth = 0;
    private int _rectHeight = 0;
    private double _zoom = 0.0;
    private double _pixelSizeX = 0.0;
    private double _pixelSizeY = 0.0;
    private int _xTextOffset = 0;
    private int _yTextOffset = 0;
    private XpSingularPort vp = null;
    private CPoint[] _polyLine = null;
    private CPoint[] _axis = null;
    private CPoint[] _text = null;
    private CPoint[] _tickLine = null;
    private String[] _textValue = null;
    private CPoint centerImagePoint = new CPoint(0);
    private CPoint imCenterPoint = new CPoint(0);
    private CPoint oneImageTick = new CPoint(0);
    private CPoint oneImageGrid = new CPoint(0);
    private CPoint imageTickDelta = new CPoint(0);
    private CPoint centerPoint = new CPoint(1);
    private CPoint oneTick = new CPoint(1);
    private CPoint oneGrid = new CPoint(1);
    private CPoint tickDelta = new CPoint(1);
    private CPoint p1 = new CPoint(1);
    private CPoint p2 = new CPoint(1);
    private CPoint p3 = new CPoint(1);
    private CPoint p4 = new CPoint(1);
    private Color col = Color.WHITE;
    private static final DecimalFormat df = new DecimalFormat("0.0");
    private boolean initPaint = true;
    private CPoint disp = new CPoint(1);
    private CPoint imp = new CPoint(0);
    private XpHandle moveHandle = null;
    private static Shape MOVE_HANDLE_SHAPE = null;
    private static Shape CONTAINMENT_SHAPE = null;
    private boolean selected = true;
    private double cmWidth;
    private double cmHeight;
    private int nbOfCmW;
    private int nbOfCmH;
    private double zoom;
    private double cmWidth_o;
    private double cmHeight_o;
    private double cmTHeight;
    private double cmTWidth;
    private double tickDeltaX;
    private double tickDeltaY;
    private int nbOfCmTH;
    private int nbOfCmTW;
    private double height_2;
    private double width_2;
    private boolean showHandle = false;
    private float[] dashPattern = new float[]{2.0f, 1.0f, 2.0f, 1.0f};
    private BasicStroke dottedStrk = new BasicStroke(1.0f, 0, 0, 10.0f, this.dashPattern, 0.0f);
    private Rectangle viewport = new Rectangle();
    private XpSingularPort colneVp = null;
    private XpImageRenderAttributes orgattr = null;
    private int vp_w = 512;
    private int vp_h = 512;
    private int w = 256;
    private int h = 256;
    private static final int HOT_SPOT = 5;

    public CvImageGrid(XpSingularPort obj) {
        this.vp = obj;
        this.init();
    }

    public CvImageGrid(XpSingularPort obj, boolean show) {
        this.showHandle = show;
        this.vp = obj;
        this.init();
        if (this.showHandle) {
            this.moveHandle = new XpHandle((XpAnchorable)this, 0, 16);
            this.moveHandle.setShape(MOVE_HANDLE_SHAPE, CONTAINMENT_SHAPE);
            this.moveHandle.setFilled(true);
            this.add(this.moveHandle);
        }
    }

    private void init() {
        if (this.vp == null || this.vp.getMedicalImageVc().getImageVc().getImage() == null) {
            System.err.println("Viewport is null.");
        } else {
            this.vp_w = this.vp.getMedicalImageVc().getWidth();
            this.vp_h = this.vp.getMedicalImageVc().getHeight();
            this._rectWidth = this.vp_w;
            this._rectHeight = this.vp_h;
            this._centerX = this._rectWidth / 2;
            this._centerY = this._rectHeight / 2;
        }
    }

    private static void createHandleShape() {
        String val = CvPropertiesManager.getProperty("cvf.Handle.Factory");
        HandleFactory factory = null;
        if (val != null) {
            factory = CvUtils.createHandleFactory(val);
            if (factory == null) {
                factory = new DefaultHandleFactory();
            }
        } else {
            factory = new DefaultHandleFactory();
        }
        XpHandle.setHandleColor(factory.getHandleColor());
        XpAppContext.setSelectedColor(factory.getHandleSelectedColor());
        XpAppContext.setUnSelectedColor(factory.getHandleUnSelectedColor());
        XpAppContext.setShadowed(true);
        MOVE_HANDLE_SHAPE = factory.getMoveHandleShape(HandleFactory.HandleStyle.CROSSHAIR);
        CONTAINMENT_SHAPE = factory.getContainmentShape();
    }

    public void initPaint(XpVisualComponent vc) {
        int i;
        if (this.vp == null || this.vp.getMedicalImageVc().getImageVc().getImage() == null) {
            if (SwingUtilities.getAncestorOfClass(XpSingularPort.class, vc) != null) {
                this.colneVp = (XpSingularPort)SwingUtilities.getAncestorOfClass(XpSingularPort.class, vc);
                this.orgattr = this.colneVp.getImageRenderAttributes();
                this.colneVp.getBounds(this.viewport);
                this.w = this.colneVp.getMedicalImageVc().getImageVc().getImage().getWidth();
                this.h = this.colneVp.getMedicalImageVc().getImageVc().getImage().getHeight();
                this.vp_w = this.colneVp.getMedicalImageVc().getWidth();
                this.vp_h = this.colneVp.getMedicalImageVc().getHeight();
                this._pixelSizeX = this.colneVp.getMedicalImageVc().getImageVc().getFrame().getPixelDimensionX();
                this._pixelSizeY = this.colneVp.getMedicalImageVc().getImageVc().getFrame().getPixelDimensionY();
            }
        } else {
            this.orgattr = this.vp.getImageRenderAttributes();
            this.vp.getBounds(this.viewport);
            this.w = this.vp.getMedicalImageVc().getImageVc().getImage().getWidth();
            this.h = this.vp.getMedicalImageVc().getImageVc().getImage().getHeight();
            this.vp_w = this.vp.getMedicalImageVc().getWidth();
            this.vp_h = this.vp.getMedicalImageVc().getHeight();
            this._pixelSizeX = this.vp.getMedicalImageVc().getImageVc().getFrame().getPixelDimensionX();
            this._pixelSizeY = this.vp.getMedicalImageVc().getImageVc().getFrame().getPixelDimensionY();
        }
        this._rectWidth = this.vp_w;
        this._rectHeight = this.vp_h;
        this._yTextOffset = 0;
        this._xTextOffset = 0;
        if (this.vp != null) {
            if (this.initPaint) {
                this.disp.setLocation(this._centerX, this._centerY, 0.0);
                this.vp.getMedicalImageVc().getImageVc().transform(this.disp, this.imp, (byte)0);
                this.imCenterPoint = this.imp;
                this.initPaint = false;
            } else {
                this.imp.setLocation(this.imCenterPoint.x, this.imCenterPoint.y, 0.0);
                this.vp.getMedicalImageVc().getImageVc().transform(this.imp, this.disp, (byte)1);
                this._centerX = this.disp.x;
                this._centerY = this.disp.y;
            }
            this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
            this.vp.getMedicalImageVc().getImageVc().transform(this.centerImagePoint, this.centerPoint, (byte)1);
            this.oneImageTick.setLocation(TICKSPACING / this._pixelSizeX, TICKSPACING / this._pixelSizeY, 0.0);
            this.vp.getMedicalImageVc().getImageVc().transform(this.oneImageTick, this.oneTick, (byte)1);
            this.oneImageGrid.setLocation(GRIDSPACING / this._pixelSizeX, GRIDSPACING / this._pixelSizeY, 0.0);
            this.vp.getMedicalImageVc().getImageVc().transform(this.oneImageGrid, this.oneGrid, (byte)1);
            this.imageTickDelta.setLocation(TICKLENGTH / 2.0 / this._pixelSizeX, TICKLENGTH / 2.0 / this._pixelSizeY, 0.0);
            this.vp.getMedicalImageVc().getImageVc().transform(this.imageTickDelta, this.tickDelta, (byte)1);
        }
        this.cmWidth_o = Math.abs(this.oneGrid.x - this.centerPoint.x);
        this.cmHeight_o = Math.abs(this.oneGrid.y - this.centerPoint.y);
        this.cmTHeight = Math.abs(this.oneTick.y - this.centerPoint.y);
        this.cmTWidth = Math.abs(this.oneTick.x - this.centerPoint.x);
        this.tickDeltaX = Math.abs(this.tickDelta.x - this.centerPoint.x);
        this.tickDeltaY = Math.abs(this.tickDelta.y - this.centerPoint.y);
        this._zoom = this.cmWidth_o / this.oneImageGrid.x;
        this.zoom = this._zoom + 0.01 < 1.0 ? 1.0 / (Math.floor(2.0 / this._zoom) + 1.0) : Math.floor(this._zoom / 4.0) + 1.0;
        this.cmWidth = this.cmWidth_o / this.zoom;
        this.nbOfCmW = (int)Math.floor((double)this._rectWidth / this.cmWidth);
        this.cmHeight = this.cmHeight_o / this.zoom;
        this.nbOfCmH = (int)Math.floor((double)this._rectHeight / this.cmHeight);
        this.nbOfCmTH = (int)Math.floor((double)this._rectHeight / this.cmTHeight);
        this.nbOfCmTW = (int)Math.floor((double)this._rectWidth / this.cmTWidth);
        this.height_2 = (double)this._rectHeight / 2.0;
        this.width_2 = (double)this._rectWidth / 2.0;
        this.initLines(this.nbOfCmW, this.nbOfCmH, this.nbOfCmTW, this.nbOfCmTH);
        double x = this._centerX;
        double y1 = this._centerY - this.height_2;
        double y2 = this._centerY + this.height_2;
        this.p1.setLocation(x, y1, 0.0);
        this.p2.setLocation(x, y2, 0.0);
        this._axis[0] = this.p1;
        this._axis[1] = this.p2;
        ++this._numberOfAxis;
        double y = this._centerY;
        double x1 = this._centerX - this.width_2;
        double x2 = this._centerX + this.width_2;
        this.p3.setLocation(x1, y, 0.0);
        this.p4.setLocation(x2, y, 0.0);
        this._axis[2] = this.p3;
        this._axis[3] = this.p4;
        ++this._numberOfAxis;
        for (i = 1; i <= (int)Math.floor((double)this.nbOfCmW / 2.0); ++i) {
            x1 = this._centerX + (double)i * this.cmWidth;
            x2 = this._centerX - (double)i * this.cmWidth;
            y1 = this._centerY - this.height_2;
            y2 = this._centerY + this.height_2;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x1, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value = GRIDSPACING * (double)i / (10.0 * this.zoom);
            this._textValue[this._numberOfTexts] = df.format(value);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(x1) + this._xTextOffset, this.doubleToint(this._centerY) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
            this._polyLine[this._numberOfPolyLines].setLocation(x2, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value1 = GRIDSPACING * (double)i / (-10.0 * this.zoom);
            this._textValue[this._numberOfTexts] = df.format(value1);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(x2) + this._xTextOffset, this.doubleToint(this._centerY) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
        }
        for (i = 1; i <= (int)Math.floor((double)this.nbOfCmH / 2.0); ++i) {
            x1 = this._centerX - this.width_2;
            x2 = this._centerX + this.width_2;
            y1 = this._centerY + (double)i * this.cmHeight;
            y2 = this._centerY - (double)i * this.cmHeight;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y1, 0.0);
            this._numberOfPolyLines += 2;
            double value2 = GRIDSPACING * (double)i / (-10.0 * this.zoom);
            this._textValue[this._numberOfTexts] = df.format(value2);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(this._centerX) + this._xTextOffset, this.doubleToint(y1) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y2, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value3 = GRIDSPACING * (double)i / (10.0 * this.zoom);
            this._textValue[this._numberOfTexts] = df.format(value3);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(this._centerX) + this._xTextOffset, this.doubleToint(y2) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
        }
        for (i = 1; i <= (int)Math.floor((double)this.nbOfCmTH / 2.0); ++i) {
            x1 = this._centerX - this.tickDeltaX;
            x2 = this._centerX + this.tickDeltaX;
            y1 = this._centerY + (double)i * this.cmTHeight;
            y2 = this._centerY - (double)i * this.cmTHeight;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y1, 0.0);
            this._numberOfTickLines += 2;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y2, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfTickLines += 2;
        }
        for (i = 1; i <= (int)Math.floor((double)this.nbOfCmTW / 2.0); ++i) {
            y1 = this._centerY - this.tickDeltaY;
            y2 = this._centerY + this.tickDeltaY;
            x1 = this._centerX + (double)i * this.cmTWidth;
            x2 = this._centerX - (double)i * this.cmTWidth;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x1, y2, 0.0);
            this._numberOfTickLines += 2;
            this._tickLine[this._numberOfTickLines].setLocation(x2, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfTickLines += 2;
        }
    }

    public void initLines(int nbOfCmW, int nbOfCmH, int nbOfCmTW, int nbOfCmTH) {
        int i;
        this._polyLine = null;
        this._text = null;
        this._axis = null;
        this._tickLine = null;
        this._numberOfPolyLines = 0;
        this._numberOfTickLines = 0;
        this._numberOfTexts = 0;
        this._numberOfAxis = 0;
        this._polyLine = new CPoint[((int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2) * 2];
        for (i = 0; i < this._polyLine.length; ++i) {
            this._polyLine[i] = new CPoint(1);
        }
        this._axis = new CPoint[4];
        for (i = 0; i < this._axis.length; ++i) {
            this._axis[i] = new CPoint(1);
        }
        this._text = new CPoint[(int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2];
        this._textValue = new String[(int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2];
        for (i = 0; i < this._text.length; ++i) {
            this._text[i] = new CPoint(1);
            this._textValue[i] = new String();
        }
        this._tickLine = new CPoint[((int)(Math.floor((double)nbOfCmTW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmTH / 2.0) * 2.0) + 2) * 2];
        for (i = 0; i < this._tickLine.length; ++i) {
            this._tickLine[i] = new CPoint(1);
        }
    }

    public void paintShape(XpVisualComponent vc, Graphics2D g) {
        int i;
        Graphics2D g2 = g;
        g2.setColor(this.col);
        this.initPaint(vc);
        if (GRIDLINES_ON) {
            for (i = 0; i < this._polyLine.length; i += 2) {
                this.drawLine(g2, this._polyLine[i], this._polyLine[i + 1], 0);
            }
        }
        for (i = 0; i <= this._axis.length - 2; i += 2) {
            this.drawLine(g2, this._axis[i], this._axis[i + 1], 0);
        }
        for (i = 0; i < this._tickLine.length - 2; i += 2) {
            this.drawLine(g2, this._tickLine[i], this._tickLine[i + 1], 0);
        }
        for (i = 0; i < this._text.length; ++i) {
            g.drawString(this._textValue[i], (int)this._text[i].x, (int)this._text[i].y);
        }
        if (this.showHandle) {
            this.setAnchorPoint();
        }
    }

    private int doubleToint(double x) {
        int val = (int)Math.floor(x + 0.5);
        return val;
    }

    public static void setLineStyle(String style) {
        LINESTYLE = style;
    }

    public static void setGridLinesOn(boolean gridON) {
        GRIDLINES_ON = gridON;
    }

    public static void setGridSpacing(double grSpacing) {
        GRIDSPACING = grSpacing;
    }

    public static void setTickSpacing(double tkSpacing) {
        TICKSPACING = tkSpacing;
    }

    public static void setTickLength(double tkLength) {
        TICKLENGTH = tkLength;
    }

    public static String getLineStyle() {
        return LINESTYLE;
    }

    public static boolean getGridLinesOn() {
        return GRIDLINES_ON;
    }

    public static double getGridSpacing() {
        return GRIDSPACING;
    }

    public static double getTickSpacing() {
        return TICKSPACING;
    }

    public static double getTickLength() {
        return TICKLENGTH;
    }

    public void drawLine(Graphics2D g, CPoint p0, CPoint p1, int offset) {
        if (LINESTYLE.equalsIgnoreCase(DOTTEDLINE)) {
            g.setStroke(this.dottedStrk);
        }
        g.drawLine(offset + (int)p0.x, offset + (int)p0.y, offset + (int)p1.x, offset + (int)p1.y);
    }

    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
        XpVisualComponent vc = (XpVisualComponent)e.getSource();
        double newCenterX = this._centerX + drag.x;
        double newCenterY = this._centerY + drag.y;
        if (newCenterX > 0.0 && newCenterX < this.viewport.getWidth() && newCenterY > 0.0 && newCenterY < this.viewport.getHeight()) {
            double dy1;
            double dx1;
            double dy;
            double dx;
            int i;
            this._centerX = newCenterX;
            this._centerY = newCenterY;
            this.disp.setLocation(this._centerX, this._centerY, 0.0);
            this.vp.getMedicalImageVc().getImageVc().transform(this.disp, this.imCenterPoint, (byte)0);
            double x1 = drag.x;
            double y1 = drag.y;
            for (i = 0; i < this._polyLine.length; i += 2) {
                dx = this._polyLine[i].point2D().getX() + x1;
                dy = this._polyLine[i].point2D().getY() + y1;
                this._polyLine[i].set(dx, dy, 0.0);
                dx1 = this._polyLine[i + 1].point2D().getX() + x1;
                dy1 = this._polyLine[i + 1].point2D().getY() + y1;
                this._polyLine[i + 1].set(dx1, dy1, 0.0);
            }
            for (i = 0; i <= this._axis.length - 2; i += 2) {
                dx = this._axis[i].point2D().getX() + x1;
                dy = this._axis[i].point2D().getY() + y1;
                this._axis[i].set(dx, dy, 0.0);
                dx1 = this._axis[i + 1].point2D().getX() + x1;
                dy1 = this._axis[i + 1].point2D().getY() + y1;
                this._axis[i + 1].set(dx1, dy1, 0.0);
            }
            for (i = 0; i < this._tickLine.length - 2; i += 2) {
                dx = this._tickLine[i].point2D().getX() + x1;
                dy = this._tickLine[i].point2D().getY() + y1;
                this._tickLine[i].set(dx, dy, 0.0);
                dx1 = this._tickLine[i + 1].point2D().getX() + x1;
                dy1 = this._tickLine[i + 1].point2D().getY() + y1;
                this._tickLine[i + 1].set(dx1, dy1, 0.0);
            }
            for (i = 0; i < this._text.length; ++i) {
                dx = this._text[i].point2D().getX() + x1;
                dy = this._text[i].point2D().getY() + y1;
                this._text[i].set(dx, dy, 0.0);
            }
        }
        vc.repaint();
    }

    public void anchorPressed(MouseEvent e, Object source) {
        this.setColor(Color.cyan);
    }

    public void anchorReleased(MouseEvent e, Object source) {
        this.setColor(Color.white);
    }

    public void setColor(Color c) {
        this.col = c;
    }

    public void setAnchorPoint() {
        this.disp.setLocation(this._centerX, this._centerY, 0.0);
        this.vp.getMedicalImageVc().getImageVc().transform(this.disp, this.imCenterPoint, (byte)0);
        this.get(0).setLocation(this.imCenterPoint.x, this.imCenterPoint.y);
    }

    public void setSelected(boolean selection) {
        this.selected = selection;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean containsROI(XpVisualComponent vc, int xx, int yy) {
        return (double)xx >= this._centerX - 5.0 && (double)xx <= this._centerX + 5.0 && (double)yy >= this._centerY - 5.0 && (double)yy <= this._centerY + 5.0;
    }

    public CPoint[] getGridLines() {
        return (CPoint[])this._polyLine.clone();
    }

    public CPoint[] getTickLines() {
        return (CPoint[])this._tickLine.clone();
    }

    static {
        CvImageGrid.createHandleShape();
    }
}

