/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.base;

import com.ge.med.cse.cvf.idc.AlphaBlender;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageListener;
import com.ge.med.terra.jami.XpOnPortLayoutManager;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OnportAlphaSliderVc
extends XpVisualComponent
implements XpImageListener,
ChangeListener {
    protected JSlider slider = new JSlider();
    protected int width;
    protected int height;
    private AlphaBlender pixelcombiner;

    public OnportAlphaSliderVc(AlphaBlender pc) {
        this.pixelcombiner = pc;
        this.setLayout(new XpOnPortLayoutManager());
        this.configureSliderModel();
        this.slider.addChangeListener(this);
        this.setSliderPosition();
    }

    public final void setImage(XpImage img) {
        if (img != null) {
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
            this.updateUI();
        }
    }

    public final void stateChanged(ChangeEvent e) {
        int val = this.slider.getValue();
        double dval = (double)val / (double)this.slider.getMaximum();
        this.pixelcombiner.setAlpha(dval);
        Component c = this.findParentByClass(this, XpImage2DVc.class);
        if (c != null) {
            ((XpImage2DVc)c).refreshImage();
            ((XpImage2DVc)c).repaint();
        }
    }

    public final void imageChanged(Object src, XpImage img) {
        this.setImage(img);
    }

    protected void configureSliderModel() {
        this.slider.setOpaque(false);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel pet = new JLabel("CT");
        JLabel ct = new JLabel("PET");
        pet.setForeground(Color.CYAN);
        ct.setForeground(Color.CYAN);
        labelTable.put(new Integer(0), pet);
        labelTable.put(new Integer(100), ct);
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
    }

    protected void setSliderPosition() {
        this.slider.setOrientation(0);
        this.add((Component)this.slider, "North");
    }
}

