/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.model.WWWLModel;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.swing.JComponent;

public class XpWindowPresetAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final XpDicomElement elemet = new XpDicomElement(8, 96);
    private static WWWLModel model = null;
    private String presetKey;
    private String modality = "";
    private TransactionLogName preset = null;
    private JComponent selectedComp = null;

    protected String getName() {
        return "XpWindowPresetAction";
    }

    public void setPreset(String presetkey) {
        this.presetKey = presetkey;
        this.preset = new TransactionLogName(presetkey);
    }

    protected void prepareModel() {
        FrameCapable frCap = (FrameCapable)((Object)this.getCapable().getCapable(FrameCapable.class.getName()));
        if (frCap.getFrame() instanceof XpDicomObject) {
            XpDicomObject object = (XpDicomObject)((Object)frCap.getFrame());
            object.getValue(elemet);
            this.modality = elemet.getStringValue();
            model = WWWLModel.getModel(this.modality);
        }
    }

    protected void setLevels() {
        double[] setting = model.getWWWL(this.presetKey);
        if (setting == null || setting.length < 2) {
            return;
        }
        double min = setting[1] - setting[0] / 2.0;
        double max = min + setting[0];
        this.getWindowLevelCapable().setWinMinMax(min, max);
        this.getWindowLevelCapable().repaint();
    }

    public void setCapable(Capable cap) {
        super.setCapable(cap);
        cap.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("data_changed") || evt.getPropertyName().equals("CONTENT_CHANGED") || evt.getPropertyName().equalsIgnoreCase("ComponentSelection")) {
                    FrameCapable frCap;
                    if (evt.getPropertyName().equalsIgnoreCase("ComponentSelection")) {
                        if (XpWindowPresetAction.this.getSelectedViewport() == XpWindowPresetAction.this.selectedComp) {
                            return;
                        }
                        XpWindowPresetAction.this.selectedComp = XpWindowPresetAction.this.getSelectedViewport();
                    }
                    if ((frCap = (FrameCapable)((Object)XpWindowPresetAction.this.getCapable().getCapable(FrameCapable.class.getName()))).getFrame() instanceof XpDicomObject) {
                        XpDicomObject object = (XpDicomObject)((Object)frCap.getFrame());
                        object.getValue(elemet);
                        XpWindowPresetAction.this.modality = elemet.getStringValue();
                        model = WWWLModel.getModel(XpWindowPresetAction.this.modality);
                        String key = "";
                        try {
                            key = model.getShortCutKey(XpWindowPresetAction.this.getName());
                            String text = model.getTitle(XpWindowPresetAction.this.getName()) + " (" + key + ")";
                            if (text != null) {
                                XpWindowPresetAction.this.putValue("Name", text);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        this.getLogger().log(Level.FINE, "{0} " + this.presetKey + "Key Action Begin " + this.preset);
        this.prepareModel();
        this.setLevels();
        this.getLogger().log(Level.FINE, "{0} " + this.presetKey + "Key Action END " + this.preset);
    }

    public static class Preset6
    extends XpWindowPresetAction {
        public Preset6() {
            this.setPreset(this.getName());
        }

        protected String getName() {
            return "Predef6";
        }
    }

    public static class Preset5
    extends XpWindowPresetAction {
        public Preset5() {
            this.setPreset(this.getName());
        }

        protected String getName() {
            return "Predef5";
        }
    }

    public static class Preset4
    extends XpWindowPresetAction {
        public Preset4() {
            this.setPreset(this.getName());
        }

        protected String getName() {
            return "Predef4";
        }
    }

    public static class Preset3
    extends XpWindowPresetAction {
        public Preset3() {
            this.setPreset(this.getName());
        }

        protected String getName() {
            return "Predef3";
        }
    }

    public static class Preset2
    extends XpWindowPresetAction {
        public Preset2() {
            this.setPreset(this.getName());
        }

        protected String getName() {
            return "Predef2";
        }
    }

    public static class Preset1
    extends XpWindowPresetAction {
        public Preset1() {
            this.setPreset(this.getName());
        }

        protected String getName() {
            return "Predef1";
        }
    }
}

