/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpWLAction
extends BaseAction {
    protected double WL_MIN;
    protected double WL_MAX;

    protected String getName() {
        return "WLAction";
    }

    protected void configure() {
        super.configure();
    }

    public void actionPerformed(ActionEvent e) {
        String mod = this.getCurrentModality();
        this.WL_MIN = CvUtils.getMinWL(mod);
        this.WL_MAX = CvUtils.getMaxWL(mod);
        double ww = this.getWindowLevelCapable().getWinMax() - this.getWindowLevelCapable().getWinMin();
        String[] params = this.getParams();
        try {
            if (params != null && params.length > 0) {
                Double wl = Double.parseDouble(params[0]);
                this.setWindowing(wl, ww);
                this.setParams(null);
            } else {
                this.getLogger().log(Level.WARNING, "Missing WL argument");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INSUFF_PARAM"));
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Parsing error for WL argument", ex);
        }
    }

    protected void setWindowing(double wl, double ww) {
        if (wl > this.WL_MAX) {
            wl = this.WL_MAX;
        } else if (wl < this.WL_MIN) {
            wl = this.WL_MIN;
        }
        double min = wl - ww / 2.0;
        double max = min + ww;
        this.getWindowLevelCapable().setWinMinMax(min, max);
        this.getWindowLevelCapable().repaint();
    }

    public static class WLDownAction
    extends XpWLAction {
        private static final TransactionLogName wlDownTID = new TransactionLogName("WLDownKeyAction");
        private static final long serialVersionUID = 1L;

        protected final void configure() {
        }

        public void actionPerformed(ActionEvent e) {
            this.getLogger().log(Level.INFO, "{0} Begin " + wlDownTID);
            String mod = this.getCurrentModality();
            double increment = Double.parseDouble(CvPropertiesManager.getProperty("cvf.WLKeyIncrement." + mod, "10"));
            this.WL_MIN = CvUtils.getMinWL(mod);
            this.WL_MAX = CvUtils.getMaxWL(mod);
            double wl = (this.getWindowLevelCapable().getWinMax() + this.getWindowLevelCapable().getWinMin()) / 2.0 - increment;
            double ww = this.getWindowLevelCapable().getWinMax() - this.getWindowLevelCapable().getWinMin();
            this.setWindowing(wl, ww);
            this.getLogger().log(Level.INFO, "{0} End " + wlDownTID);
        }

        protected String getName() {
            return "WLDownAction";
        }
    }

    public static class WLUpAction
    extends XpWLAction {
        private static final TransactionLogName wlUpTID = new TransactionLogName("WLUpKeyAction");

        protected void configure() {
        }

        public void actionPerformed(ActionEvent e) {
            this.getLogger().log(Level.INFO, "{0} Begin " + wlUpTID);
            String mod = this.getCurrentModality();
            double increment = Double.parseDouble(CvPropertiesManager.getProperty("cvf.WLKeyIncrement." + mod, "10"));
            this.WL_MIN = CvUtils.getMinWL(mod);
            this.WL_MAX = CvUtils.getMaxWL(mod);
            double wl = (this.getWindowLevelCapable().getWinMax() + this.getWindowLevelCapable().getWinMin()) / 2.0 + increment;
            double ww = this.getWindowLevelCapable().getWinMax() - this.getWindowLevelCapable().getWinMin();
            this.setWindowing(wl, ww);
            this.getLogger().log(Level.INFO, "{0} End " + wlUpTID);
        }

        protected String getName() {
            return "WLUpAction";
        }
    }
}

