/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.cse.cvf.cpanels.XPDisplayPrefsUtils;
import com.ge.med.cse.cvf.idc.XpTickMarkCapable;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import java.awt.event.ActionEvent;
import java.util.logging.Level;

public class XpVerticalTickAction
extends BaseAction {
    boolean isVerticalTickShown = false;

    protected String getName() {
        return "XP_VERTICAL_TICK";
    }

    public void actionPerformed(ActionEvent e) {
        XpTickMarkCapable tickCap = (XpTickMarkCapable)this.getCapable().getCapable(XpTickMarkCapable.class.getName());
        String[] params = this.getParams();
        if (e.getActionCommand().equals("tickmark_vertical")) {
            boolean bl = this.isVerticalTickShown = !this.isVerticalTickShown;
        }
        if (params != null && params.length > 0) {
            this.setParams(null);
            if (params[0].toLowerCase().equals("on")) {
                this.isVerticalTickShown = true;
            } else if (params[0].toLowerCase().equals("off")) {
                this.isVerticalTickShown = false;
            } else {
                this.getLogger().log(Level.WARNING, "Invalid command argument");
                this.getLogger().log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("INV_PARAM"));
            }
            this.setParams(null);
        }
        try {
            if (this.isVerticalTickShown) {
                tickCap.addTickMark(0);
            } else {
                tickCap.removeTickMark(0);
            }
            XPDisplayPrefsUtils.updateVerticalTicksStatus(this.isVerticalTickShown);
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during vertical tick mark addition , {0}", new Object[]{exp});
        }
    }
}

