/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer.treetable;

import com.ge.med.cse.apps.cdviewer.DMPhaseObject;
import com.ge.med.cse.apps.cdviewer.MVUtils;
import com.ge.med.cse.apps.cdviewer.treetable.TableRowObject;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class PhaseTableRowObject
implements TableRowObject {
    private DMObject[] refImages;
    private DMObject phaseObject;
    private DMObject refSeriesObject;
    private String id = null;

    public PhaseTableRowObject(DMObject[] phaseDMObject, DMObject refSeries) {
        this.refSeriesObject = refSeries;
        this.refImages = phaseDMObject;
        this.phaseObject = new DMPhaseObject(phaseDMObject, refSeries);
    }

    public Object getValue(DMTag dmTag) {
        return this.refSeriesObject.getValue(dmTag);
    }

    public boolean hasChild() {
        return false;
    }

    public boolean isChild() {
        return true;
    }

    public boolean isExpanded() {
        return false;
    }

    public void toggleExpanded() {
    }

    public Vector getChildren() {
        return null;
    }

    public Object getID() {
        if (this.id == null) {
            String str = "";
            if (CvImageFusionUtils.isPETSeriesTypeGATED(this.refImages[0])) {
                int framingType = CvImageFusionUtils.getFramingType(this.refImages[0]);
                str = framingType == 1113 || framingType == 1112 ? "Trig Time: " + CvImageFusionUtils.getDMTagValue(this.refImages[0], CvImageFusionUtils.TRIGGER_TIME_DMTAG) + "ms" : "Phase: " + CvImageFusionUtils.getDMTagValue(this.refImages[0], CvImageFusionUtils.FRAME_PHASE_PERCENT) + "%";
            } else if (MVUtils.isPRSeries(this.refImages[0])) {
                Object obj = this.refSeriesObject.getValue(new DMTag(32, 17));
                str = obj != null ? "Se: " + obj.toString() : "";
            } else {
                double time = Double.parseDouble(CvImageFusionUtils.getDMTagValue(this.refImages[0], CvImageFusionUtils.FRAME_REFERENCE_TIME_DMTAG).toString());
                str = "Ref Time: " + this.timeFormat("HH:mm:ss", time / 1000.0);
            }
            this.id = str;
        }
        return this.id;
    }

    protected String timeFormat(String format, double hhmmss) {
        int ss = (int)hhmmss % 100;
        int mm = (int)(hhmmss /= 100.0) % 100;
        int hh = (int)(hhmmss /= 100.0);
        Calendar cal = Calendar.getInstance();
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        Date date = new Date();
        date = cal.getTime();
        SimpleDateFormat dateFormatter = new SimpleDateFormat();
        dateFormatter.applyPattern(format);
        String result = dateFormatter.format(date);
        return result;
    }

    public DMObject getDMObject() {
        return this.phaseObject;
    }
}

