/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.apps.cdviewer;

import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpMRCTApdAnnotationConfig;
import com.ge.med.terra.jami.capable.InfoLabelReporter;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Component;
import java.awt.image.IndexColorModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComponent;

public class MVApdXRayAnnotConfig
extends XpMRCTApdAnnotationConfig {
    private static final int MAX_ROI_RESULTS = 5;
    private static final String[] roiPropName = new String[]{"roiResult1", "roiResult2", "roiResult3", "roiResult4", "roiResult5"};
    private static final String[] pads = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         "};
    private static final DecimalFormat rasf = new DecimalFormat("###0.00");
    private ArrayList roiInfoList = new ArrayList();
    private LinkedList lastSelectedRois = new LinkedList();
    private int selectedRoi = -1;
    private static final DecimalFormat df = new DecimalFormat("###0");
    private static final String DEG_SYMBOL = new String(new char[]{'\u00b0'});

    public void configAnnotation(XpAnnotationVc avc, JComponent jc) {
        XpAnnotationModel am = avc.getAnnotationModel();
        XpMedicalImage2DVc mivc = (XpMedicalImage2DVc)jc;
        XpImage2DVc viewport = mivc.getImageVc();
        if (am == null) {
            return;
        }
        this.setROIInfo(avc, viewport);
        this.setRenderAttributes(avc, mivc);
    }

    protected void setROIInfo(XpAnnotationVc avc, JComponent jc) {
        int i;
        XpAnnotationModel am = avc.getAnnotationModel();
        if (am == null) {
            return;
        }
        this.roiInfoList.clear();
        this.selectedRoi = -1;
        int nroi = 0;
        int childCount = jc.getComponentCount();
        for (i = 0; i < childCount; ++i) {
            Component c = jc.getComponent(i);
            if ((!(c instanceof XpImageRoiVc) || !XpStatisticsRoi.isShowStatistics()) && !(c instanceof InfoLabelReporter)) continue;
            String label = null;
            if (c instanceof InfoLabelReporter) {
                label = ((InfoLabelReporter)((Object)c)).getInfoLabel();
            } else {
                RoiActor ra;
                XpImageRoiVc rvc = (XpImageRoiVc)c;
                if (rvc.isVisible() && (ra = rvc.getRoiActor()) instanceof Visible && ra instanceof InfoLabelReporter) {
                    InfoLabelReporter ilr = (InfoLabelReporter)((Object)ra);
                    label = ilr.getInfoLabel();
                    if (ra.isSelected()) {
                        this.selectedRoi = nroi;
                    }
                }
            }
            if (label == null) continue;
            this.roiInfoList.add(nroi, label);
            ++nroi;
        }
        if (nroi > 0) {
            if (this.selectedRoi == -1) {
                if (this.lastSelectedRois.size() > nroi) {
                    int diff = this.lastSelectedRois.size() - nroi;
                    for (int i2 = 0; i2 < diff; ++i2) {
                        int lastSelectedIdx = Integer.parseInt((String)this.lastSelectedRois.getLast());
                        LinkedList<String> temp = new LinkedList<String>();
                        int nlsr = this.lastSelectedRois.size();
                        for (int j = 0; j < nlsr - 1; ++j) {
                            int index = Integer.parseInt((String)this.lastSelectedRois.get(j));
                            if (index > lastSelectedIdx) {
                                --index;
                            }
                            temp.add("" + index);
                        }
                        this.lastSelectedRois = temp;
                    }
                }
            } else {
                if (this.lastSelectedRois.contains("" + this.selectedRoi)) {
                    this.lastSelectedRois.remove("" + this.selectedRoi);
                }
                this.lastSelectedRois.add("" + this.selectedRoi);
            }
            int noStat = 5;
            int rsIndex = 0;
            if (this.lastSelectedRois.size() < nroi) {
                for (int i3 = 0; i3 < nroi; ++i3) {
                    if (this.lastSelectedRois.contains("" + i3)) continue;
                    this.lastSelectedRois.add("" + i3);
                }
            }
            for (int i4 = nroi - 1; i4 >= 0 && noStat > 0; --i4) {
                int index = Integer.parseInt((String)this.lastSelectedRois.get(i4));
                if (index >= this.roiInfoList.size()) continue;
                am.setProperty(roiPropName[rsIndex], (String)this.roiInfoList.get(index));
                ++rsIndex;
                --noStat;
            }
        } else {
            this.lastSelectedRois.clear();
        }
        for (i = nroi; i < 5; ++i) {
            am.setProperty(roiPropName[i], "");
        }
    }

    protected void setRenderAttributes(XpAnnotationVc avc, XpImageRenderAttributesOwner iraOwner) {
        XpAnnotationModel am = avc.getAnnotationModel();
        XpImageRenderAttributes ira = iraOwner.getImageRenderAttributes();
        if (am != null && ira != null) {
            long ww = (long)ira.getWindowWidth();
            long wl = (long)ira.getWindowLevel();
            double zoom = ira.getZoom();
            IndexColorModel icm = ira.getColormap();
            boolean setGSE = false;
            am.setProperty("windowWidth", (int)ww);
            am.setProperty("windowLevel", (int)wl);
            am.setProperty("zoomFactor", zoom);
        }
    }
}

