/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.StdAnno;

import com.ge.med.StdAnno.ApStyle;
import java.util.Collections;
import java.util.Vector;

public class ApGroup
implements Comparable {
    private ApStyle style;
    private String name;
    private int groupNumber;
    private String[] translations;
    private Vector children;
    private int currentChild;

    public void setCurrentChild(int n) {
        this.currentChild = n;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    public int getCurrentchildIndex() {
        return this.currentChild;
    }

    public void sort() {
        Collections.sort(this.children);
    }

    public ApGroup(ApStyle apStyle, String string, int n) {
        this.style = apStyle;
        this.children = new Vector();
        this.name = string;
        this.groupNumber = n;
        this.translations = new String[10];
    }

    public void setI18n(int n, String string) {
        this.translations[n] = string;
    }

    public void setGroupState(boolean bl) {
        this.style.setGroupState(this.name, bl);
        for (int i = 0; i < this.children.size(); ++i) {
            String string = (String)this.children.get(i);
            ApGroup apGroup = this.style.getGroup(string);
            apGroup.setGroupState(bl);
        }
    }

    public boolean getGroupState() {
        return this.style.getGroupState(this.name);
    }

    public String getCurrentI18n() {
        int n = this.style.getLang();
        return this.translations[n];
    }

    public String getGroupName() {
        return this.name;
    }

    public void addChild(String string) {
        this.children.add(string);
    }

    public ApGroup getFirstChildGroup() {
        this.currentChild = 0;
        if (this.children.size() > 0) {
            String string = (String)this.children.get(this.currentChild);
            ApGroup apGroup = this.style.getGroup(string);
            return apGroup;
        }
        return null;
    }

    public ApGroup getNextChildGroup() {
        ++this.currentChild;
        if (this.children.size() > this.currentChild) {
            String string = (String)this.children.get(this.currentChild);
            ApGroup apGroup = this.style.getGroup(string);
            return apGroup;
        }
        return null;
    }

    public int compareTo(Object object) {
        ApGroup apGroup = (ApGroup)object;
        if (this.groupNumber < apGroup.groupNumber) {
            return -1;
        }
        if (this.groupNumber > apGroup.groupNumber) {
            return 1;
        }
        return 0;
    }
}

